package com.amity.socialcloud.sdk.social.feed

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.google.gson.JsonObject

class AmityTextPostCreator private constructor(
    targetType: String,
    targetId: String,
    private val text: String,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?
) : AmityPostCreatorV4(targetType, targetId, metadata, mentionees) {

    class Builder internal constructor() {
        private var targetType: String = ""
        private var targetId: String = ""
        private var text: String = ""
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null

        internal fun targetType(targetType: String): Builder {
            this.targetType = targetType
            return this
        }

        internal fun targetId(targetId: String): Builder {
            this.targetId = targetId
            return this
        }

        fun text(text: String): Builder {
            this.text = text
            return this
        }

        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        fun build(): AmityTextPostCreator {
            return AmityTextPostCreator(targetType, targetId, text, metadata, mentionees)
        }
    }

    override fun getText(): String {
        return text
    }

    override fun getPostDataType(): AmityPost.DataType {
        return AmityPost.DataType.TEXT
    }


}
