package com.amity.socialcloud.sdk.social.feed

class AmityTextPostCreatorV4 private constructor(targetType: String,
                                                 targetId: String,
                                                 private val text: String)
    : AmityPostCreatorV4(targetType, targetId) {

    class Builder {
        private var targetType = ""
        private var targetId = ""
        private var text = ""

        internal fun targetType(targetType: String): Builder {
            this.targetType = targetType
            return this
        }

        internal fun targetId(targetId: String): Builder {
            this.targetId = targetId
            return this
        }

        fun text(text: String): Builder {
            this.text = text
            return this
        }


        fun build(): AmityTextPostCreatorV4 {
            return AmityTextPostCreatorV4(targetType, targetId, text)
        }
    }

    override fun getText(): String {
        return text
    }

    override fun getPostDataType(): AmityPost.DataType {
        return AmityPost.DataType.TEXT
    }
}