package com.amity.socialcloud.sdk.social.feed

import com.amity.socialcloud.sdk.core.AmityVideo
import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.google.gson.JsonObject

class AmityVideoPostCreator private constructor(
    targetType: String,
    targetId: String,
    private val text: String,
    private val videos: List<AmityVideo>,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?
) : AmityPostCreatorV4(targetType, targetId, metadata, mentionees) {

    class Builder {
        private var targetType = ""
        private var targetId = ""
        private var text = ""
        private var videos: List<AmityVideo> = mutableListOf()
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null

        internal fun targetType(targetType: String): Builder {
            this.targetType = targetType
            return this
        }

        internal fun targetId(targetId: String): Builder {
            this.targetId = targetId
            return this
        }

        fun text(text: String): Builder {
            this.text = text
            return this
        }

        internal fun videos(vararg videos: AmityVideo): Builder {
            this.videos = videos.asList()
            return this
        }

        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        fun build(): AmityVideoPostCreator {
            return AmityVideoPostCreator(targetType, targetId, text, videos, metadata, mentionees)
        }
    }

    override fun getPostDataType(): AmityPost.DataType {
        return AmityPost.DataType.VIDEO
    }

    override fun getFiles(): List<AmityVideo> {
        return videos
    }

    override fun getText(): String {
        return text
    }
}