package com.ekoapp.ekosdk.feed.edit

import com.amity.socialcloud.sdk.social.feed.PostEditor
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.ekoapp.ekosdk.internal.AmityPostAttachment
import com.google.gson.JsonObject

abstract class AmityAttachmentPostEditor internal constructor(
    postId: String,
    private val text: String?,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?,
    attachments: List<AmityPostAttachment>?
) : PostEditor(postId, metadata, mentionees, attachments) {

    override fun getData(): JsonObject {
        val data = JsonObject()
        text?.let {
            data.addProperty("text", text)
        }
        return data
    }

    abstract class Builder<in T>(postId: String): PostEditor.Builder(postId) {
        abstract fun attachments(list: List<T>): Builder<T>
    }

}