package com.ekoapp.ekosdk.feed.edit

import com.amity.socialcloud.sdk.core.AmityFile
import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.social.feed.AmityPost
import com.ekoapp.ekosdk.internal.AmityPostAttachment
import com.google.gson.JsonObject

class AmityFilePostEditor internal constructor(
    postId: String,
    private val text: String?,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?,
    attachments: List<AmityPostAttachment>?
) : AmityAttachmentPostEditor(postId, text, metadata, mentionees, attachments) {

    class Builder(private val postId: String): AmityAttachmentPostEditor.Builder<AmityFile>(postId) {
        private var text: String? = null
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null
        private var attachments: List<AmityPostAttachment>? = null
    
        override fun text(text: String?): Builder {
            return apply {
                this.text = text
            }
        }
    
        override fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }
    
        override fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }
    
        override fun attachments(attachments: List<AmityFile>): Builder {
            this.attachments = attachments.map { AmityPostAttachment(it.getFileId(),  AmityPost.DataType.FILE.getApiKey()) }
            return this
        }
    
        override fun build(): AmityFilePostEditor {
            return AmityFilePostEditor(postId, text, metadata, mentionees, attachments)
        }
    }

}