package com.ekoapp.ekosdk.feed.edit

import com.amity.socialcloud.sdk.core.file.AmityImage
import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.social.feed.AmityPost
import com.ekoapp.ekosdk.internal.AmityPostAttachment
import com.google.gson.JsonObject

class AmityImagePostEditor internal constructor(
    postId: String,
    private val text: String?,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?,
    attachments: List<AmityPostAttachment>?
) : AmityAttachmentPostEditor(postId, text, metadata, mentionees, attachments) {

    class Builder(private val postId: String): AmityAttachmentPostEditor.Builder<AmityImage>(postId) {
        private var text: String? = null
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null
        private var attachments: List<AmityPostAttachment>? = null
    
        override fun text(text: String?): Builder {
            return apply {
                this.text = text
            }
        }
    
        override fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }
    
        override fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }
    
        override fun attachments(attachments: List<AmityImage>): Builder {
            this.attachments = attachments.map { AmityPostAttachment(it.getFileId(),  AmityPost.DataType.IMAGE.getApiKey()) }
            return this
        }
    
        override fun build(): AmityImagePostEditor {
            return AmityImagePostEditor(postId, text, metadata, mentionees, attachments)
        }
    }

}