package com.amity.socialcloud.sdk.social.feed

import com.amity.socialcloud.sdk.core.AmityFile
import com.amity.socialcloud.sdk.core.AmityVideo
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.amity.socialcloud.sdk.social.AmityTextPostEditor
import com.ekoapp.ekosdk.feed.edit.AmityFilePostEditor
import com.ekoapp.ekosdk.feed.edit.AmityImagePostEditor
import com.ekoapp.ekosdk.feed.edit.AmityVideoPostEditor


class AmityTextPostEditOption internal constructor(private val postId: String) {

    fun text(text: String?): AmityTextPostEditor.Builder {
        return AmityTextPostEditor.Builder(postId).text(text)
    }
    
    fun attachments(videos: List<AmityVideo>): AmityVideoPostEditor.Builder {
        return AmityVideoPostEditor.Builder(postId).attachments(videos)
    }
    
    fun attachments(images: List<AmityImage>): AmityImagePostEditor.Builder {
        return AmityImagePostEditor.Builder(postId).attachments(images)
    }
    
    fun attachments(files: List<AmityFile>): AmityFilePostEditor.Builder {
        return AmityFilePostEditor.Builder(postId).attachments(files)
    }
    

}