package com.amity.socialcloud.sdk.social

import com.amity.socialcloud.sdk.social.feed.PostEditor
import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.google.gson.JsonObject

class AmityTextPostEditor internal constructor(
    postId: String,
    private val text: String?,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?
) : PostEditor(postId, metadata, mentionees, null) {

    override fun getData(): JsonObject {
        val data = JsonObject()
        text?.let {
            data.addProperty("text", text)
        }
        return data
    }

    class Builder(private val postId: String): PostEditor.Builder(postId) {

        private var text: String? = null
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null
    
        override fun text(text: String?): Builder {
            return apply {
                this.text = text
            }
        }
    
        override fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }
    
        override fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        override fun build(): AmityTextPostEditor {
            return AmityTextPostEditor(postId, text, metadata, mentionees)
        }
    }

}