package com.amity.socialcloud.sdk.social.feed

import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.social.domain.post.PostEditUseCase
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.AmityPostAttachment
import com.google.gson.JsonObject
import io.reactivex.Completable


abstract class PostEditor internal constructor(
    private val postId: String,
    private val metadata: JsonObject?,
    private val mentionees: List<AmityMentioneeTarget>?,
    private val attachments: List<AmityPostAttachment>?
) {
    internal abstract fun getData(): JsonObject

    fun apply(): Completable {
        return PostEditUseCase().execute(postId, getData(), metadata, mentionees, attachments).toV2()
    }
    
    abstract class Builder(private val postId: String) {
    
        abstract fun text(text: String?): Builder
    
        abstract fun metadata(metadata: JsonObject): Builder
    
        abstract fun mentionUsers(userIds: List<String>): Builder
    
        abstract fun build(): PostEditor
    }

}