package com.amity.socialcloud.sdk.social.feed

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.ekosdk.internal.usecase.post.GetCommunityFeedPagedListUseCase
import com.ekoapp.ekosdk.internal.usecase.post.GetCommunityPostPagingDataUseCase
import io.reactivex.Flowable

class AmityCommunityFeedQuery private constructor(private val communityId: String,
                                                  private val sortOption: AmityCommunityFeedSortOption,
                                                  private val isDeleted: Boolean?,
                                                  private val feedType: AmityFeedType) {

    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityPost>> {
        return GetCommunityFeedPagedListUseCase().execute(communityId, sortOption, isDeleted, feedType)
    }

    @ExperimentalPagingApi
    fun getPagingData(): Flowable<PagingData<AmityPost>> {
        return GetCommunityPostPagingDataUseCase().execute(communityId, sortOption, isDeleted, feedType, listOf())
    }

    class Builder internal constructor(private val communityId: String) {

        private var sortOption: AmityCommunityFeedSortOption = AmityCommunityFeedSortOption.LAST_CREATED
        private var isDeleted: Boolean? = null
        private var feedType: AmityFeedType = AmityFeedType.PUBLISHED

        fun sortBy(sortOption: AmityCommunityFeedSortOption): Builder {
            return apply { this.sortOption = sortOption }
        }

        fun includeDeleted(includeDeleted: Boolean): Builder {
            if (!includeDeleted) {
                this.isDeleted = false
            }
            return this
        }
        
        fun feedType(feedType: AmityFeedType): Builder {
            return apply { this.feedType = feedType }
        }

        fun build(): AmityCommunityFeedQuery {
            return AmityCommunityFeedQuery(
                communityId = communityId,
                sortOption = sortOption,
                isDeleted = isDeleted,
                feedType = feedType)
        }
    }

}