package com.amity.socialcloud.sdk.social.feed

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.ekosdk.internal.usecase.post.GetGlobalFeedPagedListUseCase
import com.ekoapp.ekosdk.internal.usecase.post.GetGlobalFeedPagingDataUseCase
import io.reactivex.Flowable

class AmityGlobalFeedQuery {

    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityPost>> {
        return GetGlobalFeedPagedListUseCase().execute()
    }

    @ExperimentalPagingApi
    fun getPagingData(): Flowable<PagingData<AmityPost>> {
        return GetGlobalFeedPagingDataUseCase().execute()
    }

    class Builder {

        fun build(): AmityGlobalFeedQuery {
            return AmityGlobalFeedQuery()
        }
    }

}