package com.amity.socialcloud.sdk.social.feed

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.ekosdk.internal.usecase.post.GetUserFeedPagedListUseCase
import com.ekoapp.ekosdk.internal.usecase.post.GetUserPostPagingDataUseCase
import io.reactivex.Flowable

class AmityUserFeedQuery private constructor(private val userId: String,
                                             private val sortOption: AmityUserFeedSortOption,
                                             private val isDeleted: Boolean?) {

    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityPost>> {
        return GetUserFeedPagedListUseCase().execute(userId, sortOption, isDeleted)
    }

    @ExperimentalPagingApi
    fun getPagingData(): Flowable<PagingData<AmityPost>> {
        return GetUserPostPagingDataUseCase().execute(userId, sortOption, isDeleted, listOf())
    }

    class Builder internal constructor(private val userId: String) {

        private var sortOption: AmityUserFeedSortOption = AmityUserFeedSortOption.LAST_CREATED
        private var isDeleted: Boolean? = null

        fun sortBy(sortOption: AmityUserFeedSortOption): Builder {
            return apply { this.sortOption = sortOption }
        }

        fun includeDeleted(includeDeleted: Boolean): Builder {
            if (!includeDeleted) {
                this.isDeleted = false
            }
            return this
        }

        fun build(): AmityUserFeedQuery {
            return AmityUserFeedQuery(userId, sortOption, isDeleted)
        }
    }

}