package com.ekoapp.ekosdk.feed.review

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.post.PostApproveUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PostDeclineUseCase
import io.reactivex.Completable

class AmityPostReviewer internal constructor(private val postId: String) {

    fun approve(): Completable {
        return PostApproveUseCase().execute(postId).toV2()
    }

    fun decline(): Completable {
        return PostDeclineUseCase().execute(postId).toV2()
    }
}