package com.amity.socialcloud.sdk.core.file

import android.os.Parcelable
import co.amity.rxupload.FileProperties
import com.google.gson.JsonArray
import com.google.gson.JsonObject


abstract class AmityFileInfo(
    private val fileId: String,
    private val filePath: String?,
    private val properties: FileProperties) : Parcelable {

    internal fun getResponseBody(): JsonObject? {
        return when {
            properties.responseBody.isJsonArray -> {
                val jsonResponseBody = (properties.responseBody as? JsonArray)?.first()
                (jsonResponseBody as? JsonObject)
            }
            properties.responseBody.isJsonObject -> {
                (properties.responseBody as? JsonObject)
            }
            else -> {
                null
            }
        }
    }

    internal fun getAttributes(): JsonObject? {
        return (getResponseBody()?.get("attributes") as? JsonObject)
    }

    internal fun getMetaData(): JsonObject? {
        return (getAttributes()?.get("metadata") as? JsonObject)
    }

    fun getFileId(): String {
        return fileId
    }

    fun getUrl(): String? {
        return getResponseBody()?.get("fileUrl")?.asString
    }

    fun getFileExtension(): String? {
        return getAttributes()?.get("extension")?.asString
    }

    fun getFileName(): String {
        return properties.fileName
    }

    fun getMimeType(): String {
        return properties.mimeType
    }

    fun getFileSize(): Int {
        return properties.fileSize.toInt()
    }

    fun getFilePath(): String? {
        return filePath
    }

    fun getProgressPercentage(): Int {
        return properties.progress
    }

}