package com.amity.socialcloud.sdk.core.file

import co.amity.rxupload.FileProperties
import com.ekoapp.ekosdk.FilePropertiesParceler
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler

@Parcelize
@TypeParceler<FileProperties, FilePropertiesParceler>
class AmityImage(
    private val id: String,
    private val path: String?,
    private val fileProperties: FileProperties
) : AmityFileInfo(id, path, fileProperties) {

    enum class Size {
        SMALL, MEDIUM, LARGE, FULL;

        val apiString: String
            get() = name.toLowerCase()
    }

    fun getUrl(size: Size): String {
        return String.format(
            "%s?size=%s",
            getResponseBody()?.get("fileUrl")?.asString,
            size.apiString
        )
    }

    fun getWidth(): Int? {
        return getMetaData()?.get("width")?.asInt
    }

    fun getHeight(): Int? {
        return getMetaData()?.get("height")?.asInt
    }

    fun isFullImage(): Boolean? {
        return getMetaData()?.get("isFull")?.asBoolean
    }

}