package com.amity.socialcloud.sdk.core

import co.amity.rxupload.FileProperties
import com.amity.socialcloud.sdk.core.file.AmityFileInfo
import com.ekoapp.ekosdk.AmityVideoResolution
import com.ekoapp.ekosdk.FilePropertiesParceler
import com.google.common.base.Objects
import com.google.gson.JsonObject
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler

@Parcelize
@TypeParceler<FileProperties, FilePropertiesParceler>
class AmityVideo(
    private val id: String,
    private val path: String?,
    private val fileProperties: FileProperties
) : AmityFileInfo(id, path, fileProperties) {

    fun getStatus(): String? {
        return (getAttributes()?.get("status")?.asString)
    }

    fun getVideoUrl(resolution: AmityVideoResolution? = null): String? {
        return if (resolution == null) {
            getUrl()
        } else {
            (getAttributes()?.get("videoUrl") as? JsonObject)?.get(resolution.apiKey)?.asString
        }
    }

    fun getResolutions(): List<AmityVideoResolution> {
        return ((getAttributes()?.get("videoUrl") as? JsonObject)?.keySet()?.toList()
            ?: emptyList())
            .fold(mutableListOf()) { acc, res ->
                acc.apply {
                    AmityVideoResolution.enumOf(res)?.let(::add)
                }
            }
    }

    enum class Quality(val apiString: String) {
        ORIGINAL("original"), HIGH("high"), MEDIUM("medium"), LOW("low");

        companion object {
            fun fromApiKey(apiKey: String?): Quality {
                for (quality in values()) {
                    if (Objects.equal(apiKey, quality.apiString)) {
                        return quality
                    }
                }
                return ORIGINAL
            }
        }
    }

    enum class Status(val apiString: String) {
        UPLOADED("uploaded"), TRANSCODING("transcoding"), TRANSCODED("transcoded"), TRANSCODE_FAILED(
            "transcodeFailed"
        );

        companion object {
            fun fromApiKey(apiKey: String?): Status {
                for (status in values()) {
                    if (Objects.equal(apiKey, status.apiString)) {
                        return status
                    }
                }
                return UPLOADED
            }
        }
    }

}