package com.amity.socialcloud.sdk.core.file

import android.net.Uri
import co.amity.rxupload.extension.upload
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.util.AppContext
import io.reactivex.Flowable
import io.reactivex.Single
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

class AmityAudioUploadService private constructor(val uri: Uri,
                                                  val uploadId: String?) : AmityUploadService<AmityUploadResult<AmityAudio>>() {

    override fun getUploadParams(): Map<String, Any> {
        return mapOf()
    }

    override fun getUploadHeaders(): Map<String, Any> {
        return mapOf()
    }

    override fun makeUploadServiceRequest(): Flowable<AmityUploadResult<AmityAudio>> {
        return uri.upload(context = AppContext.get(), path = UPLOAD_FILE_PATH,
                params = getUploadParams(), headers = getUploadHeaders(), id = uploadId)
                .subscribeOn(io.reactivex.rxjava3.schedulers.Schedulers.io())
                .observeOn(io.reactivex.rxjava3.android.schedulers.AndroidSchedulers.mainThread())
                .flatMap { fileProps ->
                    if (fileProps.progress == 100) {
                        Single.fromCallable {
                            val fileEntity = parseEkoFileEntity(fileProps.responseBody)
                            val fileDao = UserDatabase.get().fileDao()
                            fileEntity.filePath = fileProps.uri.path
                            fileDao.insert(fileEntity)
                            fileEntity
                        }
                                .subscribeOn(Schedulers.io())
                                .observeOn(AndroidSchedulers.mainThread())
                            .flatMapPublisher {
                                Flowable.just(AmityUploadResult.COMPLETE(AmityAudio(it.fileId, it.filePath, fileProps)))
                            }
                    } else {
                        Flowable.just(AmityUploadResult.PROGRESS(AmityUploadInfo(fileProps)))
                    }
                }
                .onErrorReturn {
                    val exception = parseErrorResponse(it.message)
                    AmityUploadResult.ERROR(exception)
                }.toV2()
    }

    class Builder {

        private lateinit var uri: Uri
        private var uploadId: String? = null

        internal fun fileUri(uri: Uri): Builder {
            this.uri = uri
            return this
        }

        fun uploadId(uploadId: String): Builder {
            this.uploadId = uploadId
            return this
        }

        fun build(): AmityAudioUploadService {
            return AmityAudioUploadService(uri, uploadId)
        }
    }
}