package com.amity.socialcloud.sdk.core.file

import co.amity.rxupload.FileProperties


class AmityUploadInfo internal constructor(private val fileProperties: FileProperties) {

    fun getBytesWritten(): Long {
        return fileProperties.bytesWritten
    }

    fun getProgressPercentage(): Int {
        return fileProperties.progress
    }

    fun getContentLength(): Long {
        return fileProperties.contentLength
    }

    fun getFilePath(): String? {
        return fileProperties.uri.path
    }

}