package com.amity.socialcloud.sdk.core.file

import com.amity.socialcloud.sdk.core.error.AmityException

sealed class AmityUploadResult<out T : AmityFileInfo> {
    data class PROGRESS(private val uploadInfo: AmityUploadInfo) : AmityUploadResult<Nothing>() {
        fun getUploadInfo(): AmityUploadInfo {
            return uploadInfo
        }
    }

    data class COMPLETE<out T : AmityFileInfo>(private val file: T) : AmityUploadResult<T>() {
        fun getFile(): T {
            return file
        }
    }

    data class ERROR(private val error: AmityException) : AmityUploadResult<Nothing>() {
        fun getError(): AmityException {
            return error
        }
    }

    object CANCELLED : AmityUploadResult<Nothing>()
}