package com.amity.socialcloud.sdk.core.file

import com.amity.socialcloud.sdk.core.error.AmityError
import com.amity.socialcloud.sdk.core.error.AmityException
import com.ekoapp.core.utils.getCurrentClassAndMethodNames
import com.ekoapp.ekosdk.internal.EkoFileEntity
import com.amity.socialcloud.sdk.socket.model.SocketResponse
import com.amity.socialcloud.sdk.socket.util.EkoGson
import com.amity.socialcloud.sdk.log.AmityLog
import com.google.gson.JsonElement
import io.reactivex.Flowable

abstract class AmityUploadService<T> internal constructor() : AmityUploaderParams {

    companion object {
        const val UPLOAD_FILE_PATH = "api/v3/files"
    }

    protected abstract fun makeUploadServiceRequest(): Flowable<T>

    fun transfer(): Flowable<T> {
        return makeUploadServiceRequest()
    }

    protected fun parseEkoFileEntity(serverResponse: JsonElement): EkoFileEntity {
        val data: List<EkoFileEntity> = EkoGson.get().fromJson(serverResponse, Array<EkoFileEntity>::class.java).toList()
        return data.first()
    }

    protected fun parseErrorResponse(errorResponse: String?): AmityException {
        var exception = AmityException.create("Unknown", null, AmityError.UNKNOWN)
        try {
            val errorUploadService = EkoGson.get().fromJson(errorResponse, AmityErrorUploadService::class.java)
            val response: SocketResponse = EkoGson.get().fromJson(errorUploadService.errorBody, SocketResponse::class.java)
            exception = AmityException.create(response.message, null, response.code)
        } catch (parsingException: Exception) {
            val trace = "${getCurrentClassAndMethodNames()}, ${parsingException.message ?: ""}"
            AmityLog.e(trace)
            return exception
        }
        return exception
    }
}