package com.ekoapp.ekosdk.internal

import androidx.paging.PagingDataAdapter
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.ekoapp.ekosdk.EkoObjectRepository.Companion.DEFAULT_PAGE_SIZE

private const val INVALID_PAGE_NUMBER = -1

class AmityPagingDataRefresher(val stackFromEnd: Boolean = false) : RecyclerView.OnScrollListener() {

    private var pageNumber = INVALID_PAGE_NUMBER

    override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {

    }

    override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
        val linearLayoutManager = recyclerView.layoutManager
            ?.takeIf { it is LinearLayoutManager }
            ?.let { it as LinearLayoutManager } ?: return

        val lastItem = when (stackFromEnd) {
            true -> linearLayoutManager.findFirstCompletelyVisibleItemPosition()
            false -> linearLayoutManager.findLastCompletelyVisibleItemPosition()
        }

        val pageNumber = lastItem / DEFAULT_PAGE_SIZE

        if (this.pageNumber != pageNumber) {
            this.pageNumber = pageNumber

            val adapter = recyclerView.adapter
                ?.takeIf { it is PagingDataAdapter<*, *> }
                ?.let { it as PagingDataAdapter<*, *> } ?: return

            adapter.refresh()
        }
    }
}