package com.ekoapp.ekosdk.internal;

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject

@Entity(tableName = "chat_settings")
class ChatSettingsEntity : EkoObject() {

    internal companion object {
        const val CHAT_SETTINGS_ID = "CHAT_SETTINGS_ID"
    }

    @PrimaryKey
    var settingId: String = CHAT_SETTINGS_ID
    var enabled: Boolean = false
    var isAllowMentionedChannelEnabled: Boolean = false

    override fun getId(): String {
        return settingId
    }
}