package com.ekoapp.ekosdk.internal;

import androidx.room.Entity
import androidx.room.Index
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.core.AmityTags
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.TaggedEkoObject
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "channel", indices = [Index("channelId")])
open class EkoChannelEntity : EkoObject(), TaggedEkoObject {

    @PrimaryKey
    var channelId: String = ObjectId.get().toHexString()
    var channelType: String = "community"
    var displayName: String = ""
    var avatarFileId: String? = null
    var metadata: JsonObject? = null
    private var tags: AmityTags = AmityTags()
    var memberCount = 0
    var moderatorMemberCount: Int = 1
    var messageCount = 0
    var isRateLimited = false
    var isMuted = false
    var isDeleted: Boolean = false
    var lastActivity: DateTime = DateTime.now()

    override fun getId(): String {
        return channelId
    }

    override fun getTags(): AmityTags {
        return tags
    }

    fun setTags(tags: AmityTags) {
        this.tags = tags
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other !is EkoChannelEntity) return false
        if (other === this) return true
        return other.let { channel ->
            Objects.equal(channelId, channel.channelId)
                    && Objects.equal(channelType, channel.channelType)
                    && Objects.equal(displayName, channel.displayName)
                    && Objects.equal(avatarFileId, channel.avatarFileId)
                    && Objects.equal(metadata, channel.metadata)
                    && Objects.equal(tags, channel.tags)
                    && Objects.equal(memberCount, channel.memberCount)
                    && Objects.equal(moderatorMemberCount, channel.moderatorMemberCount)
                    && Objects.equal(messageCount, channel.messageCount)
                    && Objects.equal(isRateLimited, channel.isRateLimited)
                    && Objects.equal(isMuted, channel.isMuted)
                    && Objects.equal(isDeleted, channel.isDeleted)
                    && Objects.equal(lastActivity, channel.lastActivity)
                    && Objects.equal(createdAt, channel.createdAt)
                    && Objects.equal(updatedAt, channel.updatedAt)
        }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            channelId,
            channelType,
            displayName,
            avatarFileId,
            metadata,
            tags,
            memberCount,
            moderatorMemberCount,
            messageCount,
            isRateLimited,
            isMuted,
            isDeleted,
            lastActivity,
            createdAt,
            updatedAt
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("channelId", channelId)
            add("channelType", channelType)
            add("displayName", displayName)
            add("avatarFileId", avatarFileId)
            add("metadata", metadata)
            add("tags", tags)
            add("memberCount", memberCount)
            add("moderatorMemberCount", moderatorMemberCount)
            add("messageCount", messageCount)
            add("isRateLimited", isRateLimited)
            add("isMuted", isMuted)
            add("isDeleted", isDeleted)
            add("lastActivity", lastActivity)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
        }
        return super.internalToString(toStringHelper)
    }

}