package com.ekoapp.ekosdk.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class EkoLocalFlag {

    private boolean isFlaggedByMe;
    private String syncedUpHash;


    public boolean isFlaggedByMe() {
        return isFlaggedByMe;
    }

    public void setFlaggedByMe(boolean flaggedByMe) {
        isFlaggedByMe = flaggedByMe;
    }

    public String getSyncedUpHash() {
        return syncedUpHash;
    }

    public void setSyncedUpHash(String syncedUpHash) {
        this.syncedUpHash = syncedUpHash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        EkoLocalFlag other = (EkoLocalFlag) obj;
        return Objects.equal(isFlaggedByMe, other.isFlaggedByMe)
                && Objects.equal(syncedUpHash, other.syncedUpHash);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(
                isFlaggedByMe,
                syncedUpHash
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("isFlaggedByMe", isFlaggedByMe)
                .add("syncedUpHash", syncedUpHash)
                .toString();
    }
}
