package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import androidx.room.Ignore
import androidx.room.Index
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.chat.message.AmityMessage
import com.amity.socialcloud.sdk.chat.message.AmityMessage.DataType.Companion.enumOf
import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.socket.util.EkoGson
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.TaggedEkoObject
import com.ekoapp.ekosdk.UserEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId
import org.joda.time.DateTime
import kotlin.math.max

@Entity(
    tableName = "message",
    indices = [Index("channelId"),
        Index("syncState"),
        Index(value = ["channelId", "createdAt"]),
        Index(value = ["channelId", "channelSegment"])]
)
open class EkoMessageEntity : EkoObject(), TaggedEkoObject {

    @PrimaryKey
    var messageId: String = ObjectId.get().toHexString()
    var channelId: String = ""
    var userId: String = ""
    var parentId: String? = null
    private var channelSegment: Int = 0
    var childrenNumber: Int = 0
    var editedAt: DateTime? = null
    var isDeleted: Boolean = false
    var readByCount: Int = 0
    var flagCount: Int = 0
    private var tags: AmityTags = AmityTags()
    var reactions: AmityReactionMap = AmityReactionMap()
    var reactionCount: Int = 0
    var type: String = AmityMessage.DataType.CUSTOM.apiKey
    var data: JsonObject? = null
    var fileId: String? = null
    var metadata: JsonObject? = null
    var mentionees: List<EkoMentioneesDto> = emptyList()
    // local properties
    var syncState: String = AmityMessage.State.SYNCED.stateName

    override fun getId(): String {
        return messageId
    }

    override fun getTags(): AmityTags {
        return tags
    }

    fun setTags(tags: AmityTags) {
        this.tags = tags
    }

    fun getChannelSegment(): Int {
        return channelSegment
    }

    fun setChannelSegment(channelSegment: Int) {
        this.channelSegment = max(this.channelSegment, channelSegment)
    }

    fun getDataType(): AmityMessage.DataType {
        return enumOf(type)
    }

    fun getRawData(): JsonObject? {
        data?.let { data ->
            data.addProperty("messageId", messageId)
        }
        return data
    }

    fun setState(state: AmityMessage.State) {
        this.syncState = state.stateName
    }

    override fun equals(obj: Any?): Boolean {
        return (super.equals(obj)
                && Objects.equal(messageId, (obj as EkoMessageEntity).messageId)
                && Objects.equal(channelId, obj.channelId)
                && Objects.equal(userId, obj.userId)
                && Objects.equal(parentId, obj.parentId)
                && Objects.equal(fileId, obj.fileId)
                && Objects.equal(channelSegment, obj.channelSegment)
                && Objects.equal(childrenNumber, obj.childrenNumber)
                && Objects.equal(editedAt, obj.editedAt)
                && Objects.equal(isDeleted, obj.isDeleted)
                && Objects.equal(readByCount, obj.readByCount)
                && Objects.equal(flagCount, obj.flagCount)
                && Objects.equal(tags, obj.tags)
                && Objects.equal(reactions, obj.reactions)
                && Objects.equal(reactionCount, obj.reactionCount)
                && Objects.equal(type, obj.type)
                && Objects.equal(data, obj.data)
                && Objects.equal(syncState, obj.syncState)
                && Objects.equal(metadata, obj.metadata)
                && Objects.equal(mentionees, obj.mentionees))
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            super.hashCode(),
            messageId,
            channelId,
            userId,
            parentId,
            fileId,
            channelSegment,
            childrenNumber,
            editedAt,
            isDeleted,
            readByCount,
            flagCount,
            tags,
            reactions,
            reactionCount,
            syncState,
            type,
            data,
            metadata,
            mentionees
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper): String {
        toStringHelper
            .add("messageId", messageId)
            .add("channelId", channelId)
            .add("userId", userId)
            .add("parentId", parentId)
            .add("fileId", fileId)
            .add("channelSegment", channelSegment)
            .add("childrenNumber", childrenNumber)
            .add("editedAt", editedAt)
            .add("isDeleted", isDeleted)
            .add("readByCount", readByCount)
            .add("flagCount", flagCount)
            .add("tags", tags)
            .add("reactions", reactions)
            .add("reactionCount", reactionCount)
            .add("syncState", syncState)
            .add("type", type)
            .add("data", data)
            .add("metadata", metadata)
            .add("mentionees", mentionees)
        return super.internalToString(toStringHelper)
    }
}