package com.ekoapp.ekosdk.internal

import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.UserEntity
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity
import com.ekoapp.ekosdk.internal.entity.CommunityEntity

enum class TombstoneModelType(val entityName: String) {

    USER(UserEntity::class.java.simpleName),
    MESSAGE(EkoMessageEntity::class.java.simpleName),
    POST(PostEntity::class.java.simpleName),
    CHANNEL(EkoChannelEntity::class.java.simpleName),
    COMMUNITY(CommunityEntity::class.java.simpleName),
    FOLLOW_COUNT(EkoFollowCountEntity::class.java.simpleName),
    UNKNOWN(EkoObject::class.java.simpleName);

    companion object {
        fun enumOf(entityName: String): TombstoneModelType =
            (values().find { it.entityName == entityName } ?: UNKNOWN)
    }
}