package com.ekoapp.ekosdk.internal.api

import com.amity.socialcloud.sdk.SG_HTTP_ENDPOINT
import com.amity.socialcloud.sdk.SG_MQTT_ENDPOINT
import com.amity.socialcloud.sdk.SG_SOCKET_ENDPOINT
import com.ekoapp.ekosdk.internal.data.EkoDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl
import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl
import io.reactivex.Flowable

internal object EkoEndpoint {
    private var httpUrl = ""
    private var socketUrl = ""
    private var mqttUrl = ""

    fun getHttpUrl(): String {
        val storedUrl = EkoDatabase.get().httpUrlDao().currentHttpUrl
                .defaultIfEmpty(EkoHttpUrl.create(SG_HTTP_ENDPOINT))
                .blockingGet()
                .httpUrl
        if(storedUrl != httpUrl) {
            httpUrl = storedUrl
        }
        return httpUrl
    }

    fun observeHttpUrl(): Flowable<String> {
        return EkoDatabase.get().httpUrlDao().observeCurrentHttpUrl()
            .map {
                it.httpUrl
            }
    }

    fun getSocketUrl(): String {
        val storedUrl = EkoDatabase.get().socketUrlDao().currentSocketUrl
                .defaultIfEmpty(EkoSocketUrl.create(SG_SOCKET_ENDPOINT))
                .blockingGet()
                .socketUrl
        if(storedUrl != socketUrl) {
            socketUrl = storedUrl
        }
        return socketUrl
    }

    fun getMqttUrl(): String {
        val storedUrl = EkoDatabase.get().mqttUrlDao().currentMqttUrl
            .defaultIfEmpty(EkoMqttUrl.create(SG_MQTT_ENDPOINT))
            .blockingGet()
            .mqttUrl
        if(storedUrl != mqttUrl) {
            mqttUrl = storedUrl
        }
        return mqttUrl
    }

}