package com.ekoapp.ekosdk.internal.api;

import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceForPushNotificationRequest;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceForPushNotificationResponse;
import com.ekoapp.ekosdk.internal.api.http.request.UnregisterDeviceForPushNotificationRequest;
import com.ekoapp.ekosdk.internal.api.http.request.UnregisterDeviceForPushNotificationResponse;

import io.reactivex.Single;
import retrofit2.http.Body;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.POST;

public interface EkoNotificationApi {

    @POST("v1/notification")
    Single<RegisterDeviceForPushNotificationResponse> registerNotificationToken(@Header("X-API-Key") String apiKey, @Body RegisterDeviceForPushNotificationRequest request);

    //@DELETE cannot contain @Body
    @HTTP(method = "DELETE", path = "v1/notification", hasBody = true)
    Single<UnregisterDeviceForPushNotificationResponse> unregisterNotificationToken(@Header("X-API-Key") String apiKey, @Body UnregisterDeviceForPushNotificationRequest request);
}
