package com.ekoapp.ekosdk.internal.api;

import androidx.annotation.NonNull;

import com.google.common.base.MoreObjects;

import java.util.Arrays;

import io.socket.client.Socket;

public class SocketConnectionEvent {

    final String userId;
    final boolean isConnected;
    final String event;
    final Object[] args;


    SocketConnectionEvent(@NonNull String userId, @NonNull Socket socket, @NonNull String event, @NonNull Object[] args) {
        this.userId = userId;
        this.isConnected = socket.connected();
        this.event = event;
        this.args = args;
    }

    public String getUserId() {
        return userId;
    }

    public boolean isConnected() {
        return isConnected;
    }

    public String getEvent() {
        return event;
    }

    public Object[] getArgs() {
        return args;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("userId", userId)
                .add("isConnected", isConnected)
                .add("event", event)
                .add("args", Arrays.deepToString(args))
                .toString();
    }
}
