package com.ekoapp.ekosdk.internal.api.dto;

import com.ekoapp.ekosdk.internal.data.model.EkoChannelQueryToken;
import com.google.gson.annotations.SerializedName;

import java.util.Collections;
import java.util.List;

public class ChannelQueryDto {

    @SerializedName("channels")
    private List<EkoChannelDto> channelDtoList = Collections.emptyList();

    @SerializedName("channelUsers")
    private List<EkoChannelMembershipDto> channelMembershipDtoList = Collections.emptyList();

    @SerializedName("paging")
    EkoChannelQueryToken token = new EkoChannelQueryToken();

    @SerializedName("users")
    List<EkoUserDto> users = Collections.emptyList();

    @SerializedName("files")
    List<EkoFileDto> files = Collections.emptyList();

    public List<EkoChannelDto> getChannelDtoList() {
        return channelDtoList;
    }

    public List<EkoChannelMembershipDto> getChannelMembershipDtoList() {
        return channelMembershipDtoList;
    }

    public List<EkoFileDto> getFiles() {
        return files;
    }

    public List<EkoUserDto> getUsers() {
        return users;
    }

    public EkoChannelQueryToken getToken() {
        return token;
    }

}
