package com.ekoapp.ekosdk.internal.api.dto;

import com.amity.socialcloud.sdk.core.AmityTags;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

import org.joda.time.DateTime;

public class EkoChannelDto extends EkoObjectDto {

    @SerializedName("channelId")
    private String channelId;

    @SerializedName("type")
    private String type;

    @SerializedName("displayName")
    private String displayName;

    @SerializedName("metadata")
    private JsonElement metadata;

    @SerializedName("messageCount")
    private int messageCount;

    @SerializedName("isRateLimited")
    private boolean isRateLimited;

    @SerializedName("isMuted")
    private boolean isMuted;

    @SerializedName("lastActivity")
    private DateTime lastActivity;

    @SerializedName("memberCount")
    private int memberCount;

    @SerializedName("tags")
    private AmityTags tags;

    @SerializedName("avatarFileId")
    private String avatarFileId;

    @SerializedName("isDeleted")
    private Boolean isDeleted;

    @SerializedName("moderatorMemberCount")
    private int moderatorMemberCount;

    public String getChannelId() {
        return channelId;
    }

    public String getType() {
        return type;
    }

    public String getDisplayName() {
        return displayName;
    }

    public JsonObject getMetadata() {
        if (metadata != null && metadata.isJsonObject()) {
            return metadata.getAsJsonObject();
        }
        return null;
    }

    public int getMessageCount() {
        return messageCount;
    }

    public boolean isRateLimited() {
        return isRateLimited;
    }

    public boolean isMuted() {
        return isMuted;
    }

    public DateTime getLastActivity() {
        return lastActivity;
    }

    public int getMemberCount() {
        return memberCount;
    }

    public AmityTags getTags() {
        return tags;
    }

    public String getAvatarFileId() {
        return avatarFileId;
    }

    public Boolean getDeleted() {
        if (isDeleted == null) { //TODO remove check this when BE provide in event channel.didCreate
            return false;
        } else {
            return isDeleted;
        }
    }

    public int getModeratorMemberCount() { return moderatorMemberCount; }


}
