package com.ekoapp.ekosdk.internal.api.dto;

import com.ekoapp.ekosdk.internal.data.model.EkoCommentQueryToken;
import com.google.gson.annotations.SerializedName;

import java.util.Collections;
import java.util.List;

public class EkoCommentAndUserListDto {

    @SerializedName("comments")
    List<EkoCommentDto> comments = Collections.emptyList();

    @SerializedName("users")
    List<EkoUserDto> users = Collections.emptyList();

    @SerializedName("files")
    List<EkoFileDto> files = Collections.emptyList();

    @SerializedName("paging")
    EkoCommentQueryToken token = new EkoCommentQueryToken();

    @SerializedName("commentChildren")
    List<EkoCommentDto> commentChildren = Collections.emptyList();

    @SerializedName("reactor")
    EkoReactorDto reactor;

    public List<EkoCommentDto> getComments() {
        return comments;
    }

    public List<EkoUserDto> getUsers() {
        return users;
    }

    public List<EkoFileDto> getFiles() {
        return files;
    }

    public EkoCommentQueryToken getToken() {
        return token;
    }

    public List<EkoCommentDto> getCommentChildren() {
        return commentChildren;
    }

    public EkoReactorDto getReactor() {
        return reactor;
    }
}
