package com.ekoapp.ekosdk.internal.api.dto;

import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

import org.joda.time.DateTime;

import java.util.List;

public class EkoCommentDto extends EkoObjectDto {

    @SerializedName("commentId")
    private String commentId;

    @SerializedName("_id")
    private String mid;

    @SerializedName("path")
    private String path;

    @SerializedName("referenceType")
    private String referenceType;

    @SerializedName("referenceId")
    private String referenceId;

    @SerializedName("userId")
    private String userId;

    @SerializedName("parentId")
    private String parentId;

    @SerializedName("rootId")
    private String rootId;

    @SerializedName("dataType")
    private String dataType;

    @SerializedName("childrenNumber")
    private int childrenNumber;

    @SerializedName("data")
    private JsonElement data;

    @SerializedName("metadata")
    private JsonElement metadata;

    @SerializedName("flagCount")
    private int flagCount;

    @SerializedName("hashFlag")
    private EkoFlag flag;

    @SerializedName("reactions")
    private AmityReactionMap reactions;

    @SerializedName("reactionsCount")
    private int reactionCount;

    @SerializedName("myReactions")
    private List<String> myReactions;

    @SerializedName("isDeleted")
    private Boolean isDeleted;

    @SerializedName("editedAt")
    private DateTime editedAt;

    @SerializedName("children")
    private List<String> children;

    @SerializedName("mentionees")
    List<EkoMentioneesDto> mentionees;

    @SerializedName("segmentNumber")
    private int segmentNumber;

    public String getCommentId() {
        return commentId;
    }

    public String getMid() {
        return mid;
    }

    public String getPath() {
        if (path != null) return path;
        else return "";
    }

    public String getReferenceType() {
        return referenceType;
    }

    public String getReferenceId() {
        return referenceId;
    }

    public String getUserId() {
        return userId;
    }

    public String getParentId() {
        return parentId;
    }

    public String getRootId() {
        return rootId;
    }

    public String getDataType() {
        return dataType;
    }

    public int getChildrenNumber() {
        return childrenNumber;
    }

    public JsonObject getData() {
        if (data != null && data.isJsonObject()) {
            return data.getAsJsonObject();
        }
        return null;
    }

    public JsonObject getMetaData() {
        if (metadata != null && metadata.isJsonObject()) {
            return metadata.getAsJsonObject();
        }
        return null;
    }

    public int getFlagCount() {
        return flagCount;
    }

    public EkoFlag getFlag() {
        return flag;
    }

    public AmityReactionMap getReactions() {
        return reactions;
    }

    public int getReactionCount() {
        return reactionCount;
    }

    public List<String> getMyReactions() {
        return myReactions;
    }

    public Boolean getDeleted() {
        return isDeleted;
    }

    public DateTime getEditedAt() {
        return editedAt;
    }

    public List<String> getChildren() {
        return children;
    }

    public List<EkoMentioneesDto> getMentionees() {
        return mentionees;
    }

    public int getSegmentNumber() {
        return segmentNumber;
    }
}
