package com.ekoapp.ekosdk.internal.api.dto;

import com.amity.socialcloud.sdk.core.AmityTags;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

import org.joda.time.DateTime;

import java.util.Collections;
import java.util.List;

public class EkoMessageDto extends EkoObjectDto {

    @SerializedName("messageId")
    private String messageId;

    @SerializedName("channelId")
    private String channelId;

    @SerializedName("userId")
    private String userId;

    @SerializedName("parentId")
    private String parentId;

    @SerializedName("type")
    private String type;

    @SerializedName("fileId")
    private String fileId;

    @SerializedName("channelSegment")
    private int channelSegment;

    @SerializedName("childrenNumber")
    private int childrenNumber;

    @SerializedName("editedAt")
    private DateTime editedAt;

    @SerializedName("data")
    private JsonObject data;

    @SerializedName("isDeleted")
    private boolean isDeleted;

    @SerializedName("readByCount")
    private int readByCount;

    @SerializedName("flagCount")
    private int flagCount;

    @SerializedName("tags")
    private AmityTags tags;

    @SerializedName("hashFlag")
    private EkoFlag flag;

    @SerializedName("reactions")
    private AmityReactionMap reactions;

    @SerializedName("reactionsCount")
    private int reactionCount;

    @SerializedName("myReactions")
    private List<String> myReactions;

    @SerializedName("latestReaction")
    private EkoReactorDto latestReaction;

    @SerializedName("metadata")
    private JsonObject metadata;

    @SerializedName("mentionees")
    List<EkoMentioneesDto> mentionees;

    public String getMessageId() {
        return messageId;
    }

    public String getChannelId() {
        return channelId;
    }

    public String getUserId() {
        return userId;
    }

    public String getParentId() {
        return parentId;
    }

    public String getType() {
        return type;
    }

    public String getFileId() {
        return fileId;
    }

    public int getChannelSegment() {
        return channelSegment;
    }

    public int getChildrenNumber() {
        return childrenNumber;
    }

    public DateTime getEditedAt() {
        return editedAt;
    }

    public JsonObject getData() {
        return data;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public int getReadByCount() {
        return readByCount;
    }

    public int getFlagCount() {
        return flagCount;
    }

    public AmityTags getTags() {
        return tags;
    }

    public EkoFlag getFlag() {
        return flag;
    }

    public AmityReactionMap getReactions() {
        return reactions;
    }

    public int getReactionCount() {
        return reactionCount;
    }

    public List<String> getMyReactions() {
        return myReactions;
    }

    public EkoReactorDto getLatestReaction() {
        return latestReaction;
    }

    public void setLatestReaction(EkoReactorDto latestReaction) {
        this.latestReaction = latestReaction;
    }

    public JsonObject getMetadata() {
        return metadata;
    }

    public List<EkoMentioneesDto> getMentionees() {
        return mentionees;
    }
}
