package com.ekoapp.ekosdk.internal.api.dto;

import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

import org.joda.time.DateTime;

import java.util.List;

public class EkoPostDto extends EkoObjectDto {

    @SerializedName("postId")
    private String postId;

    @SerializedName("_id")
    private String mid;

    @SerializedName("path")
    private String path;

    @SerializedName("feedId")
    private String feedId;

    @SerializedName("parentPostId")
    private String parentPostId;

    @SerializedName("postedUserId")
    private String postedUserId;

    @SerializedName("sharedUserId")
    private String sharedUserId;

    @SerializedName("dataType")
    private String dataType;

    @SerializedName("data")
    private JsonElement data;

    @SerializedName("metadata")
    private JsonElement metadata;

    @SerializedName("sharedCount")
    private int sharedCount;

    @SerializedName("targetType")
    private String targetType;

    @SerializedName("targetId")
    private String targetId;

    @SerializedName("reactions")
    private AmityReactionMap reactions;

    @SerializedName("reactionsCount")
    private int reactionCount;

    @SerializedName("myReactions")
    private List<String> myReactions;

    @SerializedName("latestReaction")
    private EkoReactorDto latestReaction;

    @SerializedName("commentsCount")
    private int commentsCount;

    @SerializedName("flagCount")
    private int flagCount;

    @SerializedName("hashFlag")
    private EkoFlag flag;

    @SerializedName("children")
    private List<String> children;

    @SerializedName("isDeleted")
    private Boolean isDeleted;

    @SerializedName("editedAt")
    private DateTime editedAt;

    @SerializedName("feedType")
    private String feedType;

    @SerializedName("mentionees")
    List<EkoMentioneesDto> mentionees;

    public String getPostId() {
        return postId;
    }

    public String getMid() { return mid; }

    public String getPath() {
        if(path != null) return path; else return "";
    }

    public String getFeedId() {
        return feedId;
    }

    public String getParentPostId() {
        return parentPostId;
    }

    public String getPostedUserId() {
        return postedUserId;
    }

    public String getSharedUserId() {
        return sharedUserId;
    }

    public String getDataType() {
        return dataType;
    }

    public JsonObject getData() {
        if (data != null && data.isJsonObject()) {
            return data.getAsJsonObject();
        }
        return null;
    }

    public JsonObject getMetadata() {
        if (metadata != null && metadata.isJsonObject()) {
            return metadata.getAsJsonObject();
        }
        return null;
    }

    public int getSharedCount() {
        return sharedCount;
    }

    public String getTargetType() {
        return targetType;
    }

    public String getTargetId() {
        return targetId;
    }

    public AmityReactionMap getReactions() {
        return reactions;
    }

    public int getReactionCount() {
        return reactionCount;
    }

    public List<String> getMyReactions() {
        return myReactions;
    }

    public EkoReactorDto getLatestReaction() {
        return latestReaction;
    }

    public int getCommentsCount() {
        return commentsCount;
    }

    public int getFlagCount() {
        return flagCount;
    }

    public EkoFlag getFlag() {
        return flag;
    }

    public List<String> getChildren() {
        return children;
    }

    public Boolean getDeleted() {
        return isDeleted;
    }

    public DateTime getEditedAt() {
        return editedAt;
    }

    public void setFeedType(String feedType) {
        this.feedType = feedType;
    }

    public String getFeedType() {
        return feedType;
    }

    public List<EkoMentioneesDto> getMentionees() {
        return mentionees;
    }
}
