package com.ekoapp.ekosdk.internal.api.dto;

import com.ekoapp.ekosdk.internal.data.model.UserFeedQueryTokenEntity;
import com.google.gson.annotations.SerializedName;

import java.util.Collections;
import java.util.List;

public class EkoPostQueryDto {

    @SerializedName("posts")
    List<EkoPostDto> posts = Collections.emptyList();

    @SerializedName("comments")
    List<EkoCommentDto> comments = Collections.emptyList();

    @SerializedName("users")
    List<EkoUserDto> users = Collections.emptyList();

    @SerializedName("paging")
    UserFeedQueryTokenEntity paging = new UserFeedQueryTokenEntity();

    @SerializedName("postChildren")
    List<EkoPostDto> children = Collections.emptyList();

    @SerializedName("files")
    List<EkoFileDto> files = Collections.emptyList();

    @SerializedName("communities")
    List<EkoCommunityDto> communities = Collections.emptyList();

    @SerializedName("categories")
    List<EkoCommunityCategoryDto> categories = Collections.emptyList();

    @SerializedName("communityUsers")
    List<EkoCommunityMembershipDto> communityUsers = Collections.emptyList();

    @SerializedName("feeds")
    List<EkoFeedDto> feeds = Collections.emptyList();

    @SerializedName("videoStreamings")
    List<EkoStreamDto> streams = Collections.emptyList();

    @SerializedName("polls")
    List<EkoPollDto> polls = Collections.emptyList();

    @SerializedName("reactor")
    EkoReactorDto reactor;

    public List<EkoPostDto> getPosts() {
        return posts;
    }

    public List<EkoCommentDto> getComments() {
        return comments;
    }

    public List<EkoUserDto> getUsers() {
        return users;
    }

    public UserFeedQueryTokenEntity getPaging() {
        return paging;
    }

    public List<EkoPostDto> getChildren() {
        return children;
    }

    public List<EkoFileDto> getFiles() {
        return files;
    }

    public List<EkoCommunityDto> getCommunities() {
        return communities;
    }

    public List<EkoCommunityCategoryDto> getCategories() {
        return categories;
    }

    public List<EkoCommunityMembershipDto> getCommunityUsers() {
        return communityUsers;
    }

    public List<EkoFeedDto> getFeeds() {
        return feeds;
    }

    public List<EkoStreamDto> getStreams() {
        return streams;
    }

    public List<EkoPollDto> getPolls() {
        return polls;
    }

    public EkoReactorDto getReactor() {
        return reactor;
    }
}
