package com.ekoapp.ekosdk.internal.api.dto;


import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class EkoStreamDto extends EkoObjectDto {

    @SerializedName("streamId")
    private String streamId;

    @SerializedName("title")
    private String title;

    @SerializedName("description")
    private String description;

    @SerializedName("metadata")
    private JsonObject metadata;

    @SerializedName("isReconnecting")
    private boolean isReconnecting;

    @SerializedName("thumbnailFileId")
    private String thumbnailFileId;

    @SerializedName("userId")
    private String userId;

    @SerializedName("status")
    private String status;

    @SerializedName("watcherUrl")
    private JsonObject watcherData;

    @SerializedName("streamerUrl")
    private JsonObject broadcasterData;

    @SerializedName("recordings")
    private JsonArray recordings;

    @SerializedName("resolution")
    private String resolution;

    @SerializedName("isDeleted")
    private boolean isDeleted;

    public String getStreamId() {
        return streamId;
    }

    public String getTitle() {
        return title;
    }

    public String getDescription() {
        return description;
    }

    public JsonObject getMetadata() {
        return metadata;
    }

    public String getThumbnailFileId() {
        return thumbnailFileId;
    }

    public String getUserId() {
        return userId;
    }

    public JsonObject getWatcherData() {
        return watcherData;
    }

    public JsonObject getBroadcasterData() {
        return broadcasterData;
    }

    public JsonArray getRecordings() {
        return recordings;
    }

    public boolean isReconnecting() {
        return isReconnecting;
    }

    public String getStatus() {
        return status;
    }

    public String getResolution() {
        return resolution;
    }

    public boolean isDeleted() {
        return isDeleted;
    }
}
