package com.ekoapp.ekosdk.internal.api.dto;

import androidx.annotation.Nullable;

import com.amity.socialcloud.sdk.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.ekoapp.ekosdk.EkoFlag;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class EkoUserDto extends EkoObjectDto {

    @SerializedName("userId")
    private String userId;

    @SerializedName("_id")
    private String mid;

    @SerializedName("path")
    private String path;

    @SerializedName("displayName")
    private String displayName;

    @SerializedName("roles")
    private AmityRoles roles;

    @SerializedName("permissions")
    private AmityPermissions permissions;

    @SerializedName("avatarFileId")
    private String avatarFileId;

    @SerializedName("avatarCustomUrl")
    private String avatarCustomUrl;

    @SerializedName("description")
    private String description;

    @SerializedName("flagCount")
    private int flagCount;

    @SerializedName("hashFlag")
    private EkoFlag flag;

    @SerializedName("metadata")
    private JsonElement metadata;

    @SerializedName("isGlobalBan")
    private Boolean isGlobalBan;

    @SerializedName("isDeleted")
    private Boolean isDeleted;


    public String getUserId() {
        return userId;
    }

    public String getMid() {
        if(mid != null) return mid; else return "";
    }

    public String getPath() {
        if(path != null) return path; else return "";
    }

    public String getDisplayName() {
        return displayName;
    }

    public AmityRoles getRoles() {
        return roles;
    }

    public AmityPermissions getPermissions() {
        return permissions;
    }

    public String getAvatarFileId() {
        return avatarFileId;
    }

    public String getAvatarCustomUrl() {
        return avatarCustomUrl;
    }

    public String getDescription() {
        return description;
    }

    public int getFlagCount() {
        return flagCount;
    }

    public EkoFlag getFlag() {
        return flag;
    }

    public JsonObject getMetadata() {
        if (metadata != null && metadata.isJsonObject()) {
            return metadata.getAsJsonObject();
        }
        return null;
    }
    @Nullable
    public Boolean isGlobalBan() {
        return isGlobalBan;
    }

    @Nullable
    public Boolean isDeleted() {
        return isDeleted;
    }
}
