package com.ekoapp.ekosdk.internal.api.dto;

import com.ekoapp.ekosdk.internal.data.model.EkoMessageQueryToken;
import com.google.gson.annotations.SerializedName;

import java.util.Collections;
import java.util.List;

public class MessageQueryDto {

    @SerializedName("messages")
    List<EkoMessageDto> messages = Collections.emptyList();

    @SerializedName("users")
    List<EkoUserDto> users = Collections.emptyList();

    @SerializedName("paging")
    EkoMessageQueryToken token = new EkoMessageQueryToken();

    @SerializedName("files")
    List<EkoFileDto> files = Collections.emptyList();


    public List<EkoMessageDto> getMessages() {
        return messages;
    }

    public List<EkoUserDto> getUsers() {
        return users;
    }

    public EkoMessageQueryToken getToken() {
        return token;
    }

    public List<EkoFileDto> getFiles() {
        return files;
    }

}
