package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;

import com.amity.socialcloud.sdk.chat.data.channel.ChannelEventPersister;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto;
import com.google.gson.Gson;

import io.reactivex.rxjava3.schedulers.Schedulers;

abstract class ChannelListener extends SocketEventListener {

    private final Gson gson = EkoGson.get();

    @Override
    protected final void onEvent(@NonNull String event, Object... args) {
        super.onEvent(event, args);
        String json = args[0].toString();
        ChannelEventDto eventData = gson.fromJson(json, ChannelEventDto.class);
        onChannelEvent(event, eventData);
    }

    void onChannelEvent(@NonNull String eventName, ChannelEventDto dto) {
        new ChannelEventPersister().persist(dto)
                .subscribeOn(Schedulers.io())
                .doOnError(throwable -> {
                    AmityLog.INSTANCE.e(throwable);
                })
                .subscribe();
    }

}

