package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.amity.socialcloud.sdk.core.mention.AmityMentionType;

public class MessageDidUpdateListener extends MessageListener {

    @NonNull
    @Override
    public String getEvent() {
        return "v3.message.didUpdate";
    }

    @Override
    protected void onEvent(@NonNull String event, Object... args) {
        super.onEvent(event, args);
        String json = args[0].toString();
        MessageQueryDto messageAndUserDto = EkoGson.get().fromJson(json, MessageQueryDto.class);
        EkoMessageDto messageDto = messageAndUserDto.getMessages().get(0);
        EkoChannelMembershipDao membershipDao = UserDatabase.get().channelMembershipDao();

        for (EkoMentioneesDto mentioneesDto : messageDto.getMentionees()) {
            boolean isMentionChannel = AmityMentionType.Companion.enumOf(mentioneesDto.getType()) == AmityMentionType.CHANNEL;
            if (isMentionChannel || mentioneesDto.getUserIds() != null
                    && mentioneesDto.getUserIds().contains(AmityCoreClient.INSTANCE.getUserId())) {
                membershipDao.updateLastMentionedSegment(messageDto.getChannelId(),
                        AmityCoreClient.INSTANCE.getUserId(), messageDto.getChannelSegment());
            }
        }
    }
}
