package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;

import com.amity.socialcloud.sdk.log.AmityLog;
import com.ekoapp.ekosdk.internal.util.Threads;

import java.util.Arrays;

import io.socket.emitter.Emitter;

public abstract class SocketEventListener implements Emitter.Listener {

    @NonNull
    public abstract String getEvent();

    @Override
    public final void call(Object... args) {
        onEvent(getEvent(), args);
    }

    protected void onEvent(@NonNull String event, Object... args) {
        final boolean isMainThread = Threads.isUiThread();
        final String msg = String.format("onEvent(main thread: %s): %s", isMainThread, event);
        if (isMainThread) {
            AmityLog.INSTANCE.w(msg);
        } else {
            AmityLog.INSTANCE.i("%s args: %s", msg, Arrays.deepToString(args));
        }
    }
}
