package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;

import com.ekoapp.ekosdk.internal.api.dto.EkoStreamListDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoStreamListMapper;
import com.amity.socialcloud.sdk.socket.util.EkoGson;

public class StreamDidStopListener extends SocketEventListener {

    @NonNull
    @Override
    public String getEvent() {
        return "v3.video-streaming.didStop";
    }

    @Override
    protected void onEvent(@NonNull String event, Object... args) {
        super.onEvent(event, args);
        String json = args[0].toString();
        updateStreamListData(json);
    }

    private void updateStreamListData(String json) {
        EkoStreamListDto dto = EkoGson.get().fromJson(json, EkoStreamListDto.class);
        EkoStreamListMapper.MAPPER.map(dto);
    }
}
