package com.ekoapp.ekosdk.internal.api.http

import android.util.Log
import com.amity.socialcloud.sdk.core.error.AmityError
import com.amity.socialcloud.sdk.core.error.AmityException
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus
import com.amity.socialcloud.sdk.core.session.model.SessionState
import okhttp3.Interceptor
import okhttp3.Response
import java.io.IOException
import java.util.*

internal class AmityErrorInterceptor(val sessionStateEventBus: SessionStateEventBus) : Interceptor {

    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val response: Response = try {
            chain.proceed(chain.request().newBuilder()
                .removeHeader("Accept-Encoding")
                .build())
        } catch (e: Exception) {
            throw e
        }

        if (!response.isSuccessful) {
            val amityError = AmityException.fromResponse(response)
            if (amityError.code == AmityError.UNAUTHORIZED_ERROR.code
                || amityError.code == AmityError.USER_IS_GLOBAL_BANNED.code
            ) {
                sessionStateEventBus.publish(SessionState.Terminated(amityError))
            }
            Log.e("SSM3", "<-- HTTP FAILED: ${amityError.code}")
        }
        return response
    }

}
