package com.ekoapp.ekosdk.internal.api.http.request;

import com.google.gson.annotations.SerializedName;

public class RegisterDeviceForPushNotificationRequest<TOKEN> {

    @SerializedName("userId")
    String userId;

    @SerializedName("deviceId")
    String deviceId;

    @SerializedName("token")
    TOKEN token;

    @SerializedName("provider")
    String provider;

    @SerializedName("platform")
    String platform;


    private RegisterDeviceForPushNotificationRequest(String userId, String deviceId, TOKEN token, String provider) {
        this.userId = userId;
        this.deviceId = deviceId;
        this.token = token;
        this.provider = provider;
        this.platform = "android";
    }

    public String getUserId() {
        return userId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public TOKEN getToken() {
        return token;
    }

    public String getProvider() {
        return provider;
    }

    public String getPlatform() {
        return platform;
    }

    public static class BaiduToken {

        @SerializedName("token")
        String token;

        @SerializedName("userId")
        String userId;

        @SerializedName("channelId")
        String channelId;


        public BaiduToken(String token, String userId, String channelId) {
            this.token = token;
            this.userId = userId;
            this.channelId = channelId;
        }

        public String getToken() {
            return token;
        }

        public String getUserId() {
            return userId;
        }

        public String getChannelId() {
            return channelId;
        }
    }

    public static <TOKEN> RegisterDeviceForPushNotificationRequest create(String userId, String deviceId, TOKEN token, String provider) {
        return new RegisterDeviceForPushNotificationRequest<>(userId, deviceId, token, provider);
    }
}
