package com.ekoapp.ekosdk.internal.api.http.request;


import com.google.gson.annotations.SerializedName;

public class StreamSession {

    @SerializedName("sessionId")
    private String sessionId;

    @SerializedName("streamId")
    private String streamId;

    @SerializedName("startTime")
    private String startTime;

    @SerializedName("endTime")
    private String endTime;

    @SerializedName("watchSeconds")
    private long watchSeconds;

    @SerializedName("resolution")
    private String resolution;


    public static StreamSession create(String sessionId, String streamId, String startTime,
                                       String endTime, long watchSeconds, String resolution) {
        StreamSession request = new StreamSession();
        request.sessionId = sessionId;
        request.streamId = streamId;
        request.startTime = startTime;
        request.endTime = endTime;
        request.watchSeconds = watchSeconds;
        request.resolution = resolution;
        return request;
    }

    public String getSessionId() {
        return sessionId;
    }

    public String getStreamId() {
        return streamId;
    }

    public String getStartTime() {
        return startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public long getWatchSeconds() {
        return watchSeconds;
    }

    public String getResolution() {
        return resolution;
    }
}
