package com.ekoapp.ekosdk.internal.api.http.request;


import com.google.gson.annotations.SerializedName;

import java.util.List;

public class StreamSessionRequest {

    @SerializedName("signature")
    private String signature;

    @SerializedName("nonceStr")
    private String nonceStr;

    @SerializedName("timestamp")
    private String timestamp;

    @SerializedName("streams")
    private List<StreamSession> streams;


    public static StreamSessionRequest create(String signature, String nonceStr, String timestamp,
                                              List<StreamSession> streams) {
        StreamSessionRequest request = new StreamSessionRequest();
        request.signature = signature;
        request.nonceStr = nonceStr;
        request.timestamp = timestamp;
        request.streams = streams;
        return request;
    }
}
