package com.ekoapp.ekosdk.internal.api.mapper;

import com.ekoapp.ekosdk.internal.api.dto.EkoChannelMembershipDto;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;

public interface EkoChannelMembershipMapper extends EkoObjectMapper<EkoChannelMembershipDto, ChannelMembershipEntity> {

    EkoChannelMembershipMapper MAPPER = dto -> {
        ChannelMembershipEntity member = new ChannelMembershipEntity();
        member.setCreatedAt(dto.getCreatedAt());
        member.setUpdatedAt(dto.getUpdatedAt());
        member.setChannelId(dto.getChannelId());
        member.setUserId(dto.getUserId());
        member.setReadToSegment(dto.getReadToSegment());
        member.setLastMentionedSegment(dto.getLastMentionedSegment());
        member.setMembership(dto.getMembership());
        member.setMuted(dto.isMuted());
        member.setBanned(dto.isBanned());
        member.setRoles(dto.getRoles());
        member.setPermissions(dto.getPermissions());
        return member;
    };
}
