package com.ekoapp.ekosdk.internal.api.mapper;

import com.ekoapp.ekosdk.internal.ChatSettingsEntity;
import com.ekoapp.ekosdk.internal.api.dto.ChatSettingsDto;

public interface EkoChatSettingsMapper extends EkoObjectMapper<ChatSettingsDto, ChatSettingsEntity> {

    EkoChatSettingsMapper MAPPER = dto -> {
        ChatSettingsEntity entity = new ChatSettingsEntity();
        entity.setEnabled(dto.getEnabled());
        if (dto.getMention() != null) {
            entity.setAllowMentionedChannelEnabled(dto.getMention().isAllowMentionedChannelEnabled());
        }
        return entity;
    };
}

