package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.google.common.collect.FluentIterable;

import java.util.Collections;
import java.util.List;

class EkoCommentListPersister extends EkoObjectPersister {

    static void persist(List<EkoCommentDto> dtoList) {
        UserDatabase userDatabase = UserDatabase.get();
        userDatabase.runInTransaction(() -> {
            persistChanges(dtoList, EkoCommentMapper.MAPPER, userDatabase.commentDao());

            for (EkoCommentDto commentDto : dtoList) {
                if(commentDto.getMyReactions() != null) {
                    final EkoReactionDao reactionDao = userDatabase.reactionDao();
                    reactionDao.deleteByReferenceIdAndUserId(commentDto.getCommentId(),
                            ReactionReferenceType.COMMENT.getValue(),
                            AmityCoreClient.INSTANCE.getUserId());
                    reactionDao.insert(FluentIterable.from(commentDto.getMyReactions())
                            .transform(reactionName -> new ReactionRepository().createMyReaction(
                                    ReactionReferenceType.COMMENT,
                                    commentDto.getCommentId(),
                                    reactionName)
                            ).toList());
                }

                final EkoCommentFlagDao flagDao = userDatabase.commentFlagDao();
                final EkoCommentFlagEntity commentFlag = new EkoCommentFlagEntity();
                commentFlag.setCommentId(commentDto.getCommentId());
                commentFlag.setFlag(commentDto.getFlag());

                final EkoCommentFlagEntity diskFlag = flagDao.getByIdNow(commentDto.getCommentId());
                if (diskFlag != null) {
                    commentFlag.setLocalFlag(diskFlag.getLocalFlag());
                    flagDao.update(commentFlag);
                } else {
                    flagDao.insert(commentFlag);
                }
            }
        });
    }
}
